<div class="wps-adminHeader">
    <img class="wps-adminHeader__logo" src="<?php echo esc_url(WP_STATISTICS_URL . 'assets/images/white-header-logo.svg'); ?>"/>

    <div class="wps-adminHeader__menuFlex">
        <a href="https://wp-statistics.com/documentation/" target="_blank" class="wps-adminHeader__menuItem">
            <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M3.12868 2.37868C2.25 3.25736 2.25 4.67157 2.25 7.5V10.5C2.25 13.3284 2.25 14.7427 3.12868 15.6213C4.00736 16.5 5.42157 16.5 8.25 16.5H9.75C12.5784 16.5 13.9927 16.5 14.8713 15.6213C15.75 14.7427 15.75 13.3284 15.75 10.5V7.5C15.75 4.67157 15.75 3.25736 14.8713 2.37868C13.9927 1.5 12.5784 1.5 9.75 1.5H8.25C5.42157 1.5 4.00736 1.5 3.12868 2.37868ZM5.4375 6C5.4375 5.68934 5.68934 5.4375 6 5.4375H12C12.3107 5.4375 12.5625 5.68934 12.5625 6C12.5625 6.31066 12.3107 6.5625 12 6.5625H6C5.68934 6.5625 5.4375 6.31066 5.4375 6ZM5.4375 9C5.4375 8.68935 5.68934 8.4375 6 8.4375H12C12.3107 8.4375 12.5625 8.68935 12.5625 9C12.5625 9.31065 12.3107 9.5625 12 9.5625H6C5.68934 9.5625 5.4375 9.31065 5.4375 9ZM6 11.4375C5.68934 11.4375 5.4375 11.6893 5.4375 12C5.4375 12.3106 5.68934 12.5625 6 12.5625H9.75C10.0607 12.5625 10.3125 12.3106 10.3125 12C10.3125 11.6893 10.0607 11.4375 9.75 11.4375H6Z" fill="white"/>
            </svg>
            <?php _e('Documentation', 'wp-statistics'); ?>
        </a>
        <a href="https://wp-statistics.com/resources-category/troubleshooting/" target="_blank" class="wps-adminHeader__menuItem">
            <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M6.28001 1.5C8.91993 1.5 11.06 3.64008 11.06 6.28001C11.06 6.76291 10.9884 7.22908 10.8552 7.66849L15.84 12.6533C16.72 13.5333 16.72 14.96 15.84 15.84C14.96 16.72 13.5333 16.72 12.6533 15.84L7.66849 10.8552C7.22908 10.9884 6.76291 11.06 6.28001 11.06C3.64008 11.06 1.5 8.91993 1.5 6.28001C1.5 5.77056 1.5797 5.27973 1.72731 4.81929L3.9884 7.07667L6.22955 6.33027L6.32964 6.23019L7.07667 3.99113L4.81294 1.72935C5.27521 1.58043 5.76821 1.5 6.28001 1.5Z" fill="white" fill-opacity="0.8"/>
            </svg>
            <?php _e('Troubleshooting', 'wp-statistics'); ?>
        </a>
        <div class="wps-adminHeader__menuItem mega">
            <svg class="icon" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M9 1.5C4.8675 1.5 1.5 4.8675 1.5 9C1.5 13.1325 4.8675 16.5 9 16.5C13.1325 16.5 16.5 13.1325 16.5 9C16.5 4.8675 13.1325 1.5 9 1.5ZM6 9.75C5.58 9.75 5.25 9.4125 5.25 9C5.25 8.5875 5.5875 8.25 6 8.25C6.4125 8.25 6.75 8.5875 6.75 9C6.75 9.4125 6.42 9.75 6 9.75ZM9 9.75C8.58 9.75 8.25 9.4125 8.25 9C8.25 8.5875 8.5875 8.25 9 8.25C9.4125 8.25 9.75 8.5875 9.75 9C9.75 9.4125 9.42 9.75 9 9.75ZM12 9.75C11.58 9.75 11.25 9.4125 11.25 9C11.25 8.5875 11.5875 8.25 12 8.25C12.4125 8.25 12.75 8.5875 12.75 9C12.75 9.4125 12.42 9.75 12 9.75Z" fill="white" fill-opacity="0.8"/>
            </svg>
            <?php _e('More', 'wp-statistics'); ?>
            <svg class="chevron" width="12" height="7" viewBox="0 0 12 7" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M1.13172 1.76883L5.63588 6.27288C5.72032 6.35734 5.8349 6.40479 5.95435 6.40479C6.07382 6.40479 6.18838 6.35731 6.27284 6.27285L10.7768 1.7688C10.9527 1.5929 10.9527 1.30774 10.7768 1.13184C10.6009 0.955973 10.3157 0.955943 10.1398 1.13184L5.95435 5.31739L1.76868 1.13184C1.68073 1.04389 1.56545 0.999933 1.45018 0.999933C1.33491 0.999933 1.21963 1.04389 1.13169 1.13187C0.955817 1.30777 0.955818 1.59294 1.13172 1.76883Z" fill="white" fill-opacity="0.8"/>
                <path d="M6.36043 6.36043L6.36043 6.36043C6.25274 6.46812 6.10669 6.52865 5.95435 6.52865C5.80207 6.52865 5.65598 6.46817 5.5483 6.36046C5.54829 6.36046 5.54829 6.36045 5.54828 6.36044L1.04413 1.85642C0.819868 1.63215 0.819865 1.26857 1.04409 1.0443L6.36043 6.36043ZM6.36043 6.36043L10.8644 1.85638C11.0886 1.63212 11.0886 1.26853 10.8644 1.04426C10.6401 0.820024 10.2765 0.819984 10.0522 1.04426L10.1385 1.13049M6.36043 6.36043L10.1385 1.13049M10.1385 1.13049L10.0522 1.04426L5.95434 5.14222M10.1385 1.13049L5.95434 5.14222M5.95434 5.14222L1.85626 1.04426C1.74414 0.93214 1.59695 0.876072 1.45018 0.876072C1.30341 0.876072 1.15622 0.93214 1.04409 1.0443L5.95434 5.14222Z" stroke="white" stroke-opacity="0.8" stroke-width="0.247723"/>
            </svg>

            <div class="wps-adminHeader__submenu">

                <?php
                // Generate links for WP Statistics admin pages
                $subMenuItems = array(
                    'wps_settings_page'     => __('Settings', 'wp-statistics'),
                    'wps_optimization_page' => __('Optimization', 'wp-statistics'),
                    'wps_plugins_page'      => __('Add-Ons', 'wp-statistics'),
                );

                $currentItem = isset($_GET['page']) ? sanitize_text_field($_GET['page']) : '';
                foreach ($subMenuItems as $menuKey => $menuTitle) {
                    $activeClass = ($currentItem === $menuKey) ? 'active-item' : '';
                    $url         = esc_url(admin_url('admin.php?page=' . $menuKey));
                    echo '<a href="' . $url . '" class="wps-adminHeader__submenuItem ' . $activeClass . '">' . $menuTitle . '</a>';
                }
                ?>

                <a href="https://wp-statistics.com/product/add-ons-bundle/" target="_blank" class="wps-adminHeader__submenuItem with-badge">
                    <?php _e('Upgrade to Bundle', 'wp-statistics'); ?>
                    <span class="badge"><?php _e('Save 50%', 'wp-statistics'); ?></span>
                </a>
            </div>

        </div>
    </div>

    <div class="wps-adminHeader__activation">
        <?php
        $activatedAddOns = \WP_Statistics\Service\Admin\AddOnDecorator::countActivatedAddOns();
        if ($activatedAddOns) {
            echo '<span></span>';
            printf(__('License Status: %d of %d activated', 'wp-statistics'), $activatedAddOns, count(get_option('wp_statistics_activate_addons', [])));
        } ?>
    </div>
</div>